//
//  Guided Spline.js
//
//  v.090131 first version
//  v.100302 quick fix for 5.3

//  (c) 2009 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

//

var splHolder = new Array;
var splList = new Array;

function buildUI(obj) {
    
    obj.setParameter("name","Guided Spline");
    
    obj.addParameterInt("steps",50, 10, 1000, true,true);
    
    obj.addParameterInt("sub path num", 0, 0, 100, true, true);
    
    obj.addParameterFloat("start",0.0,0,1,true,true);
    obj.addParameterFloat("end",1.0,0,1,true,true);

}

function buildObject(obj) {
    var start = obj.getParameter("start");
    var end = obj.getParameter("end");
    var steps = obj.getParameter("steps");
    var subpath = obj.getParameter("sub path num");
    
    if (obj.childCount() > 0) {
        var base = obj.childAtIndex(0);
        
        if (base.family() == SPLINEFAMILY) {
            var splCore = base.modCore();
            var splMat = base.objMatrix();
            
            if (splCore.pathCount() > subpath) {
                 spl = splCore.cache(subpath);
                 if (spl != null) {
                     splHolder = spl;
                     cacheSplineLength();
                 }
            } else {
                //OS.messageBox('A sub path No.'+subpath+' was not detected.',"Please check sub path count of guide spline.");
                return;
            }
            
            
            var objCore = obj.core();
            var dist = Math.abs(end - start);
            var segCount = Math.ceil(dist * steps);
            var seg = (segCount > 1)? dist / (segCount - 1) : 0.0;
            
            for (var i = 0;i < segCount;i++) {
                var p = pointFromPercentage(start + i*seg, splMat);
                if (i == 0) {
                    objCore.move(p);
                } else {
                    objCore.line(p);
                }
            }
        }
    }
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}

